 /* ============ */
/* exchisq.c	*/
/* ============ */
#include <stdio.h>
#include <stdlib.h>
#include <mconf.h>
#include <math.h>
#include <miscdefs.h>
#include <freqdefs.h>

#define	NUM_PROBS	100
#define LOW_PROB	1.0e-8

/* ==================================================================== */
/* ExecChiSqTest - Executes Chi-Square Test For Frequency Test		*/
/* ==================================================================== */
void
ExecChiSqTest(CHISQ_STRU * ChiSqData)
{
    int     k;
    double  ChiSqProbs[NUM_PROBS];
    double  DegFree, LoLimit, HiLimit;
    double  KnMinusStat, KnMinusProb, KnPlusStat,  KnPlusProb;

    /* -------------------------------- */
    /* Get Control Parameters From User */
    /* -------------------------------- */
    SetChiSqControls(ChiSqData);
    fprintf(stderr, "\n"); fflush(NULL);

    /* ------------------------ */
    /* Initialize Variate Count */
    /* ------------------------ */
    ChiSqData->TotNumGen = 0;

    /* ------------------------- */
    /* Generate Random Numbers,  */
    /* Calculate Chi-Square Data */
    /* ------------------------- */
    DegFree = ChiSqData->NumElements - 1;
    ChiSqDist(LOW_PROB, DegFree, &LoLimit, &HiLimit);


    for (k = 0; k < NUM_PROBS; ++k)
    {
	/* ------------------------------ */
	/* Calculate Chi-Square Statistic */
	/* ------------------------------ */
	ChiSqFreq(ChiSqData);

	fprintf(stderr, "\rPass %3d (of %d), %8ld  Total Random Numbers",
	    k+1, NUM_PROBS, ChiSqData->TotNumGen);

	/* -------------------------------- */
	/* Calculate Chi-Square Probability */
	/* -------------------------------- */
	if (ChiSqData->ChiSqValu < LoLimit)
	{
	      ChiSqProbs[k] = LOW_PROB;
	}
	else if (ChiSqData->ChiSqValu > HiLimit)
	{
	      ChiSqProbs[k] = 1.0 - LOW_PROB;
	}
	else
	{
		ChiSqProbs[k] = chdtr(DegFree, ChiSqData->ChiSqValu);
	}

	P(printf("Chi-Square Value Calculated from %7lu Variates  = %f\n",
		ChiSqData->NumVariates, ChiSqData->ChiSqValu));
	P(printf("Chi-Square Probability on %5u Degrees of Freedom = %f\n",
		ChiSqData->NumElements-1, ChiSqProbs[k]));
	P(fprintf(stderr, "\r%3d of %d", k+1, NUM_PROBS));

	if (ChiSqProbs[k] < 0)
	{
	    fprintf(stderr, "\nChiSqFreq(): Function chdtr() "
		"Returned Negative Probability -  Can't Happen.\n");
	    P(printf("ChiSqFreq: MaxSize    = %lu\n",
		ChiSqData->NumElements));
	}
    }
    fprintf(stderr, "\n"); fflush(NULL);

    KSCalc(ChiSqProbs, NUM_PROBS, &KnPlusStat, &KnPlusProb,
	&KnMinusStat, &KnMinusProb);

    printf("\nKolmogorov-Smirnov Statistics and Probabilities"
	   " on Chi-Square Data\n");

    printf("\tK(%d)+ = %f (Knuth) or %9f%%\n", NUM_PROBS,
	sqrt((double)NUM_PROBS)*KnPlusStat, 100*KnPlusProb);

    printf("\tK(%d)+ = %f (Knuth) or %9f%%\n", NUM_PROBS,
	sqrt((double)NUM_PROBS)*KnMinusStat, 100*KnMinusProb);

    printf("\nThis Run Required %ld Random Numbers\n\n",
	ChiSqData->TotNumGen);
}
